//
//  CSNSStringExtensions.h
//  CDMaker
//
//  Created by Alastair Houghton on 11/08/2005.
//  Copyright 2005 Coriolis Systems Limited. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSString (CSNSStringExtensions)

+ (NSString *)stringWithArguments:(NSString *)arg0, ... 
  NS_REQUIRES_NIL_TERMINATION;
+ (NSString *)stringWithArgumentArray:(NSArray *)args;
- (NSString *)stringByAppendingArguments:(NSString *)arg0, ...
  NS_REQUIRES_NIL_TERMINATION;

- (NSString *)stringByEscapingShellCharacters;
- (NSString *)stringByEscapingCharactersInSet:(NSCharacterSet *)toEscape;
- (NSString *)unescapedString;
- (NSString *)unescapedStringWithMap:(const char *)map;
- (NSString *)stringByEscapingCharactersInSet:(NSCharacterSet *)toEscape
				      withMap:(const char *)map;

+ (NSString *)sizeStringFromUnsignedLongLong:(unsigned long long)size
					base:(unsigned)base;
+ (NSString *)sizeStringFromUnsignedLongLong:(unsigned long long)size;

@end

@interface NSMutableString (CSNSStringExtensions)

- (void)appendArgument:(id)arg;

@end
